package jadean.ui.propertytesters;

import jadean.ui.handlers.HandlerUtilities;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;


public class ContextMenuPropertyTester extends PropertyTester {

	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		if (receiver instanceof ISelection) {
			ISelection selection = (ISelection) receiver;
			if (selection != null && selection instanceof IStructuredSelection) {
				Object obj = ((IStructuredSelection) selection).getFirstElement();
				if (obj != null) {
					String[] natureIDs = HandlerUtilities.getNatureIds(obj);
					if (natureIDs == null) {
						return false;
					}
					String[] supportedNatureIDs = HandlerUtilities.getSupportedNatureIds(natureIDs);
					if (supportedNatureIDs == null) {
						return false;
					}
					return supportedNatureIDs.length == 1;
				}
			}
		}
		return false;
	}

}
